/*
  フルカラーLEDイルミネーション
*/

#define SAMPLING 200
void ilm(byte led,float bgn,float fnsh) //LEDの輝度をジワーっと変化させる
{
  float d;
  d=(fnsh-bgn)/255.0;
  for(int n=0;n<256;n++)
  {
    analogWrite(led,bgn);
    bgn+=d;
    delay(10);
  }
  delay(100);
}

//LEDの接続ピン
  #define G 9
  #define R 10
  #define B 11

//LEDの輝度最大値
  #define RMAX 255
  #define GMAX 255
  #define BMAX 255

int led_max(int rgb)
{
  switch(rgb)
  {
    case R:return(RMAX);
    case G:return(GMAX);
    case B:return(BMAX);
   default:return(0);
  }
}

//イルミネーション本体ここから
void ilum()
{
  const char str1[]={0xb2,0xd9,0xd0,0xc8,0x2d,0xbc,0xae,0xdd,'\0'};//イルミネーション
  byte dd,j0,j1,j2,k0,k1,k2;
  const byte led[6][3] = {
    {R,G,B},
    {R,B,G},
    {G,R,B},
    {G,B,R},
    {B,G,R},
    {B,R,G}
  };
  lcd.clear();
  lcd.print(str1);
  pinMode(G,OUTPUT);
  pinMode(R,OUTPUT);
  pinMode(B,OUTPUT);
  if(!digitalRead(STSW)){
    setting();
    while(digitalRead(STSW)){
      phlev();
      delay(200);
    }
  }  
  start2();
  delay(1000); 
  while(1)
  {
     while(phlev())
      {
        dd=random(6);
        j0=led[dd][0];
        j1=led[dd][1];
        j2=led[dd][2];
        k0=led_max(j0);
        k1=led_max(j1);
        k2=led_max(j2);
   
        ilm(j2,0,k2);
        ilm(j2,k2,0);
        ilm(j1,0,k1);
        ilm(j1,k1,0);
        ilm(j0,0,k0);
        for(int n=0;n<random(5)+1;n++){
          ilm(j1,0,k1);
          ilm(j0,k0,0);
          ilm(j2,0,k2);
          ilm(j1,k1,0);
          ilm(j0,0,k0);
          ilm(j2,k2,0);
        }
        ilm(j0,k0,0);
      }
      delay(200);
  }
}

