/*
  デジタル時計
*/

void printDigits(byte d){ //値を２桁の数値で表示
  nprint('0',d);
}


void digitalClockDisplay(boolean sw){ //時刻の表示。引数swによって表示のし方を帰ている。
  const char cc1= 0xa1;
  const char cc2= 0xdf;

  lcd.setCursor(0,0);
  if(sw){
      lcd.print(DateTime.Year+1900,DEC);
      lcd.print("/");
  }
  printDigits(DateTime.Month+1);
  lcd.print("/");
  if(!sw) printDigits(DateTime.Day);
  if (sw) lcd.setCursor(2,1);
  else lcd.setCursor(6,0);
  if(DateTime.Second%2) lcd.print(cc1);
  else lcd.print(cc2);
  lcd.setCursor(0,1);  
  if(sw){
     printDigits(DateTime.Day);
     lcd.setCursor(3,1);
  }
  printDigits(DateTime.Hour);
  lcd.print(":");
  printDigits(DateTime.Minute);
  if(!sw){
    lcd.print(":");
    printDigits(DateTime.Second);
  }
}


unsigned int getnum(byte d, byte px, byte py, char t[])//A5の電圧値を読んで与えられた上限までの数値を返す
{
  unsigned int buff;
//  const char a[]={'j','i','\0'};
  lcd.setCursor(1,1);
  lcd.print(t);
  while(digitalRead(STSW)){
    buff = d/1023.0*analogRead(5);
    if(d==11 || d==30) buff++; 
    lcd.setCursor(px,py);
    nprint('0',buff);
  }
  while(!digitalRead(STSW));
  //lcd.clear();
  tone(16,440,50);
  return(buff);
}

time_t prevtime;
//デジタル時計本体ここから
void clock() {
  char yy[]={0xc8,0xdd,'\0'};
  char mm[]={0xb6,0xde,0xc2,'\0'};
  char dd[]={0xa0,0xa0,0xc6,0xc1,'\0'};
  char hh[]={0xbc,0xde,'\0'};
  char mn[]={0xcc,0xdd,'\0'};
  char ss[]={0xcb,0xde,0xae,0xb3,'\0'};
  boolean oldsw,sw = 0;
  boolean snd = 1;
  byte byo,fun,ji,hi,tsuki;
  unsigned int nen;
  lcd.setCursor(0,0);
  lcd.print("20");

//年月日分秒のセット
  nen=getnum(35,2,0,yy)+2000;
  //lcd.setCursor(4,0);
  lcd.print("/");
  tsuki=getnum(11,5,0,mm);
  //lcd.setCursor(7,0);
  lcd.print("/");
  hi=getnum(30,0,1,dd);
  lcd.clear();
  ji=getnum(23,0,0,hh);
  lcd.print(':');
  fun=getnum(59,3,0,mn);
  lcd.print(':');
  byo=getnum(59,6,0,ss);
  prevtime = DateTime.makeTime(byo,fun,ji,hi,tsuki-1,nen);
  DateTime.sync(prevtime);

  //以下，時計動作
  while(1){
    if(digitalRead(STSW)==LOW){
      if(DateTime.Second>29)
        prevtime = DateTime.makeTime(0,DateTime.Minute+1,DateTime.Hour,DateTime.Day,DateTime.Month,DateTime.Year+1900);
      else
        prevtime = DateTime.makeTime(0,DateTime.Minute,DateTime.Hour,DateTime.Day,DateTime.Month,DateTime.Year+1900);      
      DateTime.sync(prevtime);
      lcd.clear();
      DateTime.available();
      digitalClockDisplay(oldsw=0);
      tone(16,440,50);
    }
    while(digitalRead(STSW)==LOW){
      DateTime.sync(prevtime);
    };
    sw=(analogRead(5)>1000);
    if(sw!=oldsw){
      lcd.clear();
      oldsw=sw;
    }
    DateTime.available();
    digitalClockDisplay(sw);
    if((DateTime.Second+DateTime.Minute)==0){
      if(snd){//正時に時報を鳴らす
        tone(16,770,50);
        snd=0;
      }      
    }else snd=1;
  }
}


