/*
 小学生向けブレッドボード電子工作スケッチ
   copyright by Kimio Kosaka
*/

// include the library code:
#include <LiquidCrystal.h>
#include <DateTime.h>
#include <DateTimeStrings.h>

#define halt while(1)
#define TRUE 1
#define FALSE 0 
#define LED 10
#define STSW 3

// initialize the library with the numbers of the interface pins
LiquidCrystal lcd(2,4,5,6,7,8);

#include "_common.h"  //共通関数
#include "ramen.h"  //キッチンタイマー
#include "temp.h"  //デジタル温度計
#include "organ.h"  //電子オルガン
#include "osc.h"  //トーン・ジェネレータ
#include "ilum.h"  //フルカラーLEDイルミネーション
#include "alarm.h"  //光アラーム
#include "knock.h"  //音アラーム
#include "hello.h"  //テスト用ＬチカとHello world
#include "clock.h"  //デジタルクロック

void setup() {
  pinMode(STSW,INPUT);
  pinMode(LED-1,OUTPUT);
  pinMode(LED+1,OUTPUT);
  pinMode(LED,OUTPUT);
  lcd.begin(8, 2); // set up the LCD's number of rows and columns: 
  lcd.clear();
  analogReference(DEFAULT);
  switch(select()){
    case 0:hello();
    case 1:ramen();
    case 2:clock();
    case 3:temp(0); //温度計 LM61 用
    case 4:ilum();
    case 5:osc();
    case 6:organ();
    case 7:temp(1); //温度計 LM35 用
    case 8:alarm(0); //小さいとＯＮ
    case 9:alarm(1); //大きいとＯＮ
    case 10:knock(0); //A4の圧電素子を監視
    case 11:knock(1); //A2の圧電素子を監視
    case 12:;
    case 13:;
    case 14:;
    case 15:;
    default:;
  }
}

void loop() {
}



